#include <windows.h>
#include <stdio.h>

#define MIRC_DLL(func) int WINAPI func(HWND mWnd, HWND aWnd, char *data, char *parms, BOOL show, BOOL nopause)
#define ASSERT_CORE_TEMP if (coreTempData == NULL) return 0;

typedef struct {
    DWORD  mVersion;
    HWND   mHwnd;
    BOOL   mKeep;
} LOADINFO;

typedef struct
{
	unsigned int	uiLoad[256];
	unsigned int	uiTjMax[128];
	unsigned int	uiCoreCnt;
	unsigned int	uiCPUCnt;
	float			fTemp[256];
	float			fVID;
	float			fCPUSpeed;
	float			fFSBSpeed;
	float			fMultipier;	
	char			sCPUName[100];
	unsigned char	ucFahrenheit;
	unsigned char	ucDeltaToTjMax;
} CORE_TEMP_SHARED_DATA;

HANDLE mapFile;
CORE_TEMP_SHARED_DATA *coreTempData = NULL;
int index;

void WINAPI LoadDll(LOADINFO *info)
{
	mapFile = OpenFileMapping(FILE_MAP_READ, FALSE, "CoreTempMappingObject");
	if (mapFile == NULL) {
		info->mKeep = 0;
		return;
	}
	coreTempData = (CORE_TEMP_SHARED_DATA*)MapViewOfFile(mapFile, FILE_MAP_READ, 0, 0, 0);
	if (coreTempData == NULL) {
		CloseHandle(mapFile);
		info->mKeep = 0;
		return;
	}
}

int WINAPI UnloadDll(int timeout)
{
	UnmapViewOfFile(coreTempData);
	CloseHandle(mapFile);
	return 1;
}

MIRC_DLL(GetCoreLoad)
{
	ASSERT_CORE_TEMP;
	index = atoi(data);
	if (index < 0 || index > 255)
		return 0;
	sprintf(data, "%u", coreTempData->uiLoad[index]);
	return 3;
}

MIRC_DLL(GetTjMax)
{
	ASSERT_CORE_TEMP;
	index = atoi(data);
	if (index < 0 || index > 255)
		return 0;
	sprintf(data, "%u", coreTempData->uiTjMax[index]);
	return 3;
}

MIRC_DLL(GetCoreCount)
{
	ASSERT_CORE_TEMP;
	sprintf(data, "%u", coreTempData->uiCoreCnt);
	return 3;
}

MIRC_DLL(GetCpuCount)
{
	ASSERT_CORE_TEMP;
	sprintf(data, "%u", coreTempData->uiCPUCnt);
	return 3;
}

MIRC_DLL(GetTemp)
{
	ASSERT_CORE_TEMP;
	index = atoi(data);
	if (index < 0 || index > 255)
		return 0;
	sprintf(data, "%.2f", coreTempData->fTemp[index]);
	return 3;
}

MIRC_DLL(GetVid)
{
	ASSERT_CORE_TEMP;
	sprintf(data, "%.2f", coreTempData->fVID);
	return 3;
}

MIRC_DLL(GetCpuSpeed)
{
	ASSERT_CORE_TEMP;
	sprintf(data, "%.2f", coreTempData->fCPUSpeed);
	return 3;
}

MIRC_DLL(GetFsbSpeed)
{
	ASSERT_CORE_TEMP;
	sprintf(data, "%.2f", coreTempData->fFSBSpeed);
	return 3;
}

MIRC_DLL(GetMultiplier)
{
	ASSERT_CORE_TEMP;
	sprintf(data, "%.2f", coreTempData->fMultipier);
	return 3;
}

MIRC_DLL(GetCpuName)
{
	ASSERT_CORE_TEMP;
	strcpy(data, coreTempData->sCPUName);
	return 3;
}

MIRC_DLL(IsFahrenheit)
{
	ASSERT_CORE_TEMP;
	strcpy(data, coreTempData->ucFahrenheit ? "1" : "0");
	return 3;
}

MIRC_DLL(IsDistanceToTjMax)
{
	ASSERT_CORE_TEMP;
	strcpy(data, coreTempData->ucDeltaToTjMax ? "1" : "0");
	return 3;
}

MIRC_DLL(IsCoreTempRunning)
{
	strcpy(data, coreTempData ? "1" : "0");
	return 3;
}
