// MSNMsgrObject.h 
// Copyright (c) 2002 - 2009 Ivan Mendez Licensed under GNU GPL
// For more information, see License.txt

#ifndef MSNMSGROBJECT_H
#define MSNMSGROBJECT_H

struct DECLSPEC_UUID("0f66a667-732d-4509-a595-9e31358da19c") IMSNMsgrObject : IDispatch
{
public:
	virtual STDMETHODIMP CreateUser (BSTR bstrLogonName,struct IMSNMsgrService * pService,struct IMSNMsgrUser * * ppUser ) = 0;
	virtual STDMETHODIMP Logon (BSTR bstrUser, BSTR bstrPassword, struct IMSNMsgrService * pService ) = 0;
	virtual STDMETHODIMP Logoff ( ) = 0;
	virtual STDMETHODIMP GetList (enum MLIST mList, struct IMSNMsgrUsers * * ppUsers ) = 0;
	virtual STDMETHODIMP GetLocalLogonName ( BSTR * pbstrName ) = 0;
	virtual STDMETHODIMP GetLocalFriendlyName ( BSTR * pbstrName ) = 0;
	virtual STDMETHODIMP SetLocalState ( enum MSTATE pmState ) = 0;
	virtual STDMETHODIMP GetLocalState ( enum MSTATE * pmState ) = 0;
	virtual STDMETHODIMP SetMessagePrivacy ( enum MMSGPRIVACY pmmpSetting ) = 0;
	virtual STDMETHODIMP GetMessagePrivacy ( enum MMSGPRIVACY * pmmpSetting ) = 0;
	virtual STDMETHODIMP SetPrompt ( enum MPROMPT pmpSetting ) = 0;
	virtual STDMETHODIMP GetPrompt ( enum MPROMPT * pmpSetting ) = 0;
	virtual STDMETHODIMP SendAppInvite (struct IMSNMsgrUser * pUser,long lCookie, BSTR bstrAppGUID, BSTR bstrAppName, BSTR bstrAppURL, 
		long lInviteType, enum MMSGTYPE mmtType,long * plCookie ) = 0;
	virtual STDMETHODIMP SendAppInviteAccept ( struct IMSNMsgrUser * pUser, long lCookie, long lInviteType, enum MMSGTYPE mmtType,long * plCookie ) = 0;
	virtual STDMETHODIMP SendAppInviteCancel ( struct IMSNMsgrUser * pUser, long lCookie, long hrReason, enum MMSGTYPE mmtType, long * plCookie ) = 0;
	virtual STDMETHODIMP SetLocalOption (enum MLOCALOPTION option, VARIANT pvSetting ) = 0;
	virtual STDMETHODIMP GetLocalOption (enum MLOCALOPTION option, VARIANT * pvSetting ) = 0;
	virtual STDMETHODIMP FindUser (BSTR bstrFirstName,BSTR bstrLastName, BSTR bstrCity,BSTR bstrState, BSTR bstrCountry,long * plCookie ) = 0;
	virtual STDMETHODIMP SendInviteMail (BSTR bstrEmailAddress, long lFindCookie, long lFindIndex, long lLCID, long * plCookie ) = 0;
	virtual STDMETHODIMP RequestURLPost (enum MURLTYPE muType, BSTR bstrAdditionalInfo, long * plCookie ) = 0;
	virtual STDMETHODIMP GetIMSessions (struct IMSNMsgrIMSessions * * ppIMSessions ) = 0;
	virtual STDMETHODIMP CreateIMSession (VARIANT vUser, struct IMSNMsgrIMSession * * ppIMSession ) = 0;
	virtual STDMETHODIMP SessionRequestAccept (struct IMSNMsgrIMSession * pIMsgrIMSession, long hrReason ) = 0;
	virtual STDMETHODIMP SessionRequestCancel (struct IMSNMsgrIMSession * pIMsgrIMSession, long hrReason ) = 0;
	virtual STDMETHODIMP GetServices ( struct IMSNMsgrServices * * ppServices ) = 0;
	virtual STDMETHODIMP GetUnreadEmail (enum MFOLDER mFolder,long * pcUnreadEmail ) = 0;
};

struct DECLSPEC_UUID("b56f43f0-8f2a-4e5c-aa77-660426e00505") IMSNMsgrObject2 : IMSNMsgrObject
{
public:
	virtual STDMETHODIMP SendFileTransferInvite ( struct IMSNMsgrUser * pUser, long lCookie,  BSTR bstrFilePath, MMSGTYPE mmtType,long * plCookie ) = 0;
	virtual STDMETHODIMP SendFileTransferInviteAccept (struct IMSNMsgrUser * pUser,long lCookie,BSTR bstrFilePath,MMSGTYPE mmtType,long * plCookie ) = 0;
	virtual STDMETHODIMP SendFileTransferInviteCancel (struct IMSNMsgrUser * pUser,long lCookie,long hrReason,MMSGTYPE mmtType,long * plCookie ) = 0;
	virtual STDMETHODIMP CancelFileTransfer (struct IMSNMsgrUser * pUser,long lCookie,long hrReason, MMSGTYPE mmtType,long * plCookie ) = 0;
	virtual STDMETHODIMP FileTransferStatus (long lCookie,struct IMSNMsgrUser * pUser,long * plStatus, BSTR * pbstrFilePath,long * plTotalBytes,
		long * plBytesTransferred ) = 0;
	virtual STDMETHODIMP SetLocalProperty (enum MUSERPROPERTY ePropType, VARIANT pvPropVal ) = 0;
	virtual STDMETHODIMP GetLocalProperty (enum MUSERPROPERTY ePropType, VARIANT * pvPropVal ) = 0;
	virtual STDMETHODIMP SendPage (struct IMSNMsgrUser * pUser, BSTR bstrMessage, enum MUSERPROPERTY ePhoneType, long * plCookie ) = 0;
	virtual STDMETHODIMP SendCustomInviteMail (BSTR bstrEmailAddress,long lFindCookie,long lFindIndex,long lLCID,BSTR bstrCustomText,long * plCookie ) = 0;
};

struct DECLSPEC_UUID("299D310C-E1E1-4322-8FA8-ABFA87542614") IMSNMsgrService : IDispatch
{
public:
	virtual STDMETHODIMP GetServiceName(BSTR* pbstrServiceName) = 0;
	virtual STDMETHODIMP LogonName(BSTR* pbstrName)  = 0;
	virtual STDMETHODIMP SetFriendlyName(BSTR pbstrName) = 0;
	virtual STDMETHODIMP GetFriendlyName(BSTR* pbstrName) = 0;
	virtual STDMETHODIMP GetCapabilities(long* plCapabilities) = 0;
	virtual STDMETHODIMP GetStatus(enum MSVCSTATUS* pmStatus) = 0;
	virtual STDMETHODIMP Logoff() = 0;
	virtual STDMETHODIMP FindUser(BSTR bstrFirstName,BSTR bstrLastName, BSTR bstrCity,BSTR bstrState, BSTR bstrCountry,long * plCookie ) = 0;
	virtual STDMETHODIMP SendInviteMail(BSTR bstrEmailAddress,long lFindCookie,long lFindIndex,long lLCID,long * plCookie ) = 0;
	virtual STDMETHODIMP RequestURLPost(enum MURLTYPE muType, BSTR bstrAdditionalInfo, long * plCookie ) = 0;
	virtual STDMETHODIMP SetProfileField(enum MPFLFIELD mpFLFIELD,VARIANT pvFieldValue);
	virtual STDMETHODIMP GetProfileField(enum MPFLFIELD mpFLFIELD,VARIANT pvFieldValue);

};

struct DECLSPEC_UUID("8771CF61-D9C6-471d-A6F5-7C84244EE3E3") IMSNMsgrServices : IDispatch
{
public:
	virtual STDMETHODIMP SetPrimaryService (IMSNMsgrService* ppService) = 0;
	virtual STDMETHODIMP GetPrimaryService (IMSNMsgrService** ppService) = 0;
	virtual STDMETHODIMP GetCount (long* pcServices) = 0;
	virtual STDMETHODIMP Item (long Index, IMSNMsgrService** ppService) = 0;
	virtual STDMETHODIMP _NewEnum(IUnknown** ppUnknown) = 0;
};

const CLSID CLSID_MSNMsgrObject = {0xf5f545a6,0x39c4,0x40b5,{0x81,0x4d,0xb4,0x50,0x40,0xa8,0x9f,0xb5}};

#endif MSNMSGROBJECT_H