// MessengerEvents.cpp 
// Copyright (c) 2002 - 2009 Ivan Mendez Licensed under GNU GPL
// For more information, see License.txt
#include "MessengerEvents.h"


Host *pHost;

extern IMessenger3 *msn;

//----------------------------------------------------------------------------
// Host class implementation
//----------------------------------------------------------------------------

Host::Host()
{
    IConnectionPointContainer* pCPContainer;
    m_dwRefCount = 1;
    m_pMessengerEvents = new MessengerEvents(this); 
    HRESULT hr = msn->QueryInterface(IID_IConnectionPointContainer,reinterpret_cast<void **>(&pCPContainer));
    m_dwCookie = 0;
    if (SUCCEEDED(hr))
    {
        hr = pCPContainer->FindConnectionPoint(DIID_DMessengerEvents, &m_pConnectionPoint);
        if (SUCCEEDED(hr))
        {
            hr = m_pConnectionPoint->Advise(m_pMessengerEvents, &m_dwCookie);
        }
        
        if (pCPContainer) pCPContainer->Release();
    }
}


Host::~Host()
{
    m_pConnectionPoint->Unadvise(m_dwCookie);
    m_pConnectionPoint->Release();
    if (m_pMessengerEvents) delete m_pMessengerEvents;
}

ULONG STDMETHODCALLTYPE Host::AddRef()
{ 
    return ++m_dwRefCount;
}
ULONG STDMETHODCALLTYPE Host::Release()
{
    if(!--m_dwRefCount)
        delete this;
    return m_dwRefCount;
}


STDMETHODIMP Host::QueryInterface(REFIID iid, void ** ppvObject) {
    if(ppvObject == NULL) return E_INVALIDARG;
    *ppvObject = NULL;
    if(iid == IID_IUnknown)
        *ppvObject = (IUnknown*)this;
    else if(iid == DIID_DMessengerEvents || iid == IID_IDispatch)
        *ppvObject = m_pMessengerEvents;
    if(*ppvObject == NULL) return E_NOINTERFACE;
    AddRef();
    return S_OK;
}




MessengerEvents::MessengerEvents(Host *phost)
{
	m_pHost = phost; 
}

MessengerEvents::~MessengerEvents() {}

STDMETHODIMP MessengerEvents::Invoke(DISPID dispIdMember, REFIID riid, LCID lcid,
                                     WORD wFlags, DISPPARAMS FAR* pDispParams,
                                     VARIANT FAR* parResult,
                                     EXCEPINFO FAR* pExcepInfo,
                                     unsigned int FAR* puArgErr)
{

	char str[900];
	char temp[900];
	char name[900];
	BSTR bstrName = NULL;
	HRESULT hr;
	BSTR bstrTemp = NULL;
	LONG pHwnd;
	IMessengerContact *pIMContact = NULL;
	IMessengerGroup *pIMGroup = NULL;
	IMessengerWindow * pIMWindow = NULL;
    if (!pDispParams)
        return E_INVALIDARG;
    
    switch (dispIdMember)
    {
	    case DISPID_MUAE_ONSIGNIN:
			Signal("OnSignin");
			break;  
		case DISPID_MUAE_ONSIGNOUT:
			Signal("OnSignout");
			break;
		case DISPID_MUAE_ONAPPSHUTDOWN:
			Signal("OnAppShutdown");
			break;
		case DISPID_MUAE_ONUSERBLOCKCHANGE:
			hr = pDispParams->rgvarg[2].intVal;
			if (hr != S_OK)
				break;
			pDispParams->rgvarg[1].pdispVal->QueryInterface(__uuidof(IMessengerContact),reinterpret_cast<void **>(&pIMContact));
			pIMContact->get_SigninName(&bstrName);
			bstr_to_char(bstrName,name,900);
			_snprintf_s(str,900,_TRUNCATE,"OnContactBlockChange %s %u",name,(pDispParams->rgvarg[0].boolVal == VARIANT_TRUE ? 1 : 0));
			Signal(str);
			break;
		case DISPID_MUAE_ONUSERFRIENDLYNAMECHANGE:
			hr = pDispParams->rgvarg[2].intVal;
			if (hr != S_OK)
				break;
			pDispParams->rgvarg[1].pdispVal->QueryInterface(__uuidof(IMessengerContact),reinterpret_cast<void **>(&pIMContact));
			pIMContact->get_SigninName(&bstrName);
			bstrTemp = pDispParams->rgvarg[0].bstrVal;
			bstr_to_char(bstrName,name,900);
			bstr_to_char(bstrTemp,temp,900);
			_snprintf_s(str,900,_TRUNCATE,"OnContactFriendlyNameChange %s %s",name,temp);
			Signal(str);
			break;
		case DISPID_MUAE_ONLISTADD:
			hr = pDispParams->rgvarg[1].intVal;
			if (hr != S_OK)
				break;
			pDispParams->rgvarg[0].pdispVal->QueryInterface(__uuidof(IMessengerContact),reinterpret_cast<void **>(&pIMContact));
			pIMContact->get_SigninName(&bstrName);
			bstr_to_char(bstrName,name,900);
			_snprintf_s(str,900,_TRUNCATE,"OnContactListAdd %s",name);
			Signal(str);
			break;
		case DISPID_MUAE_ONLISTREMOVE:
			hr = pDispParams->rgvarg[1].intVal;
			if (hr != S_OK)
				break;
			pDispParams->rgvarg[0].pdispVal->QueryInterface(__uuidof(IMessengerContact),reinterpret_cast<void **>(&pIMContact));
			pIMContact->get_SigninName(&bstrName);
			bstr_to_char(bstrName,name,900);
			_snprintf_s(str,900,_TRUNCATE,"OnContactListRemove %s",name);
			Signal(str);
			break;
		case DISPID_MUAE_ONUSERPAGERCHANGE:
			hr = pDispParams->rgvarg[2].intVal;
			if (hr != S_OK)
				break;
			pDispParams->rgvarg[1].pdispVal->QueryInterface(__uuidof(IMessengerContact),reinterpret_cast<void **>(&pIMContact));
			pIMContact->get_SigninName(&bstrName);
			bstr_to_char(bstrName,name,900);
			_snprintf_s(str,900,_TRUNCATE,"OnContactPagerChange %s",name);
			Signal(str);
			break;
		case DISPID_MUAE_ONUSERPHONECHANGE:
			hr = pDispParams->rgvarg[3].intVal;
			if (hr != S_OK)
				break;
			pDispParams->rgvarg[2].pdispVal->QueryInterface(__uuidof(IMessengerContact),reinterpret_cast<void **>(&pIMContact));
			pIMContact->get_SigninName(&bstrName);
			bstrTemp = pDispParams->rgvarg[0].bstrVal;
			bstr_to_char(bstrName,name,900);
			bstr_to_char(bstrTemp,temp,900);
			_snprintf_s(str,900,_TRUNCATE,"OnContactPhoneChange %s %u %s",name,pDispParams->rgvarg[1].intVal,temp);
			Signal(str);
			break;
		case DISPID_MUAE_ONUSERSTATECHANGE:
			pDispParams->rgvarg[1].pdispVal->QueryInterface(__uuidof(IMessengerContact),reinterpret_cast<void **>(&pIMContact));
			pIMContact->get_SigninName(&bstrName);
			bstr_to_char(bstrName,name,900);
			_snprintf_s(str,900,_TRUNCATE,"OnContactStatusChange %s %s",name,Status(static_cast<MISTATUS>(pDispParams->rgvarg[0].intVal)));
			Signal(str);
			break;
		case DISPID_MUAE_ONMYSTATECHANGE:
			hr = pDispParams->rgvarg[1].intVal;
			if (hr != S_OK)
				break;
			_snprintf_s(str,900,_TRUNCATE,"OnMyStatusChange %s",Status(static_cast<MISTATUS>(pDispParams->rgvarg[0].intVal)));
			Signal(str);
			break;
		case DISPID_MUAE_ONMYFRIENDLYNAMECHANGE:
			bstrTemp = pDispParams->rgvarg[0].bstrVal;
			bstr_to_char(bstrTemp,temp,900);
			_snprintf_s(str,900,_TRUNCATE,"OnMyFriendlyNameChange %s",temp);
			Signal(str);
			break;
	   
		case DISPID_MUAE_ONUNREADEMAILCHANGE:
			_snprintf_s(str,900,_TRUNCATE,"OnUnreadEmailChange %u",pDispParams->rgvarg[2].intVal);
			Signal(str);
			break;
		case DISPID_MUAE_ADD_USRGRP:
			hr = pDispParams->rgvarg[2].intVal;
			if (hr != S_OK)
				break;
			pDispParams->rgvarg[0].pdispVal->QueryInterface(__uuidof(IMessengerContact),reinterpret_cast<void **>(&pIMContact));
			pIMContact->get_SigninName(&bstrName);
			pDispParams->rgvarg[1].pdispVal->QueryInterface(__uuidof(IMessengerGroup),reinterpret_cast<void **>(&pIMGroup));
			pIMGroup->get_Name(&bstrTemp);
			bstr_to_char(bstrName,name,900);
			bstr_to_char(bstrTemp,temp,900);
			_snprintf_s(str,900,_TRUNCATE,"OnContactAddedToGroup %s %s",name,temp);
			Signal(str);
			break;
		case DISPID_MUAE_ADDGROUP:
			hr = pDispParams->rgvarg[1].intVal;
			if (hr != S_OK)
				break;
			pDispParams->rgvarg[0].pdispVal->QueryInterface(__uuidof(IMessengerGroup),reinterpret_cast<void **>(&pIMGroup));
			pIMGroup->get_Name(&bstrTemp);
			bstr_to_char(bstrTemp,temp,900);
			_snprintf_s(str,900,_TRUNCATE,"OnGroupAdded %s",temp);
			Signal(str);
			break;
		case DISPID_MUAE_RENAMEGROUP:
			hr = pDispParams->rgvarg[1].intVal;
			if (hr != S_OK)
				break;
			pDispParams->rgvarg[0].pdispVal->QueryInterface(__uuidof(IMessengerGroup),reinterpret_cast<void **>(&pIMGroup));
			pIMGroup->get_Name(&bstrTemp);
			bstr_to_char(bstrTemp,temp,900);
			_snprintf_s(str,900,_TRUNCATE,"OnGroupNameChanged %s",temp);
			Signal(str);
			break;
		case DISPID_MUAE_REMOVEGROUP:
			hr = pDispParams->rgvarg[1].intVal;
			if (hr != S_OK)
				break;
			pDispParams->rgvarg[0].pdispVal->QueryInterface(__uuidof(IMessengerGroup),reinterpret_cast<void **>(&pIMGroup));
			pIMGroup->get_Name(&bstrTemp);
			bstr_to_char(bstrTemp,temp,900);
			_snprintf_s(str,900,_TRUNCATE,"OnGroupRemoved %s",temp);
			Signal(str);
			break;
		case  DISPID_MUAE_ONMYPHONECHANGE:
			bstrTemp = pDispParams->rgvarg[0].bstrVal;
			bstr_to_char(bstrTemp,temp,900);
			_snprintf_s(str,900,_TRUNCATE,"OnMyPhoneChange %d %s",pDispParams->rgvarg[1].intVal,temp);
			Signal(str);
			break;
		case DISPID_MUAE_ONIMWINDOWCREATED:
			pDispParams->rgvarg[0].pdispVal->QueryInterface(__uuidof(IMessengerWindow),reinterpret_cast<void **>(&pIMWindow));
			pIMWindow->get_HWND(&pHwnd);
			_snprintf_s(str,900,_TRUNCATE,"OnIMWindowCreated %#x",pHwnd);
			Signal(str);
			break;
		case DISPID_MUAE_ONIMWINDOWDESTROYED:
			pDispParams->rgvarg[0].pdispVal->QueryInterface(__uuidof(IMessengerWindow),reinterpret_cast<void **>(&pIMWindow));
			pIMWindow->get_HWND(&pHwnd);
			_snprintf_s(str,900,_TRUNCATE,"OnIMWindowDestroyed %#x",pHwnd);
			Signal(str);
			break;
		default:
			break;
    }
	SysFreeString(bstrName);
	SysFreeString(bstrTemp);
	if (pIMContact) pIMContact->Release();
	if (pIMGroup) pIMGroup->Release();
	return S_OK;
}



STDMETHODIMP MessengerEvents::QueryInterface(REFIID iid, void ** ppvObject)
{ 
    return m_pHost->QueryInterface(iid, ppvObject); 
}

ULONG STDMETHODCALLTYPE MessengerEvents::AddRef()
{
	return m_pHost->AddRef(); 
}

ULONG STDMETHODCALLTYPE MessengerEvents::Release()
{ 
    return m_pHost->Release(); 
}


HRESULT STDMETHODCALLTYPE MessengerEvents::GetTypeInfoCount(unsigned int FAR* pctinfo)
{ 
	return E_NOTIMPL;
}

HRESULT STDMETHODCALLTYPE MessengerEvents::GetTypeInfo(unsigned int iTInfo, LCID  lcid,
                                                       ITypeInfo FAR* FAR*  ppTInfo)
{ 
	return E_NOTIMPL;
}

HRESULT STDMETHODCALLTYPE MessengerEvents::GetIDsOfNames(REFIID riid,
                                                         OLECHAR FAR* FAR* rgszNames,
                                                         unsigned int cNames,
                                                         LCID lcid,
                                                         DISPID FAR* rgDispId)
{ 
	return E_NOTIMPL; 
}
