// MessengerEvents.h 
// Copyright (c) 2002 - 2009 Ivan Mendez Licensed under GNU GPL
// For more information, see License.txt
#ifndef _MESSENGEREVENTS_H_
#define _MESSENGEREVENTS_H_

#include "msn.h"

//
// Dispatch IDs for DMessengerEvents
// 
#define DISPID_MUAE_ONSIGNIN				  0x400
#define DISPID_MUAE_ONSIGNOUT				  0x401
#define DISPID_MUAE_ONLISTADD				  0x402
#define DISPID_MUAE_ONLISTREMOVE			  0x403
#define DISPID_MUAE_ONUSERFRIENDLYNAMECHANGE  0x404
#define DISPID_MUAE_ONMYFRIENDLYNAMECHANGE	  0x405
#define DISPID_MUAE_ONUSERSTATECHANGE		  0x406
#define DISPID_MUAE_ONMYSTATECHANGE 		  0x407
#define DISPID_MUAE_ONAPPSHUTDOWN			  0x408
#define DISPID_MUAE_ONMYPROPERTYCHANGE		  0x409
#define DISPID_MUAE_ONUSERPROPERTYCHANGE	  0x40a
#define DISPID_MUAE_ONUSERBLOCKCHANGE		  0x40b
#define DISPID_MUAE_ONUSERPAGERCHANGE		  0x40c
#define DISPID_MUAE_ONUSERPHONECHANGE		  0x40d
#define DISPID_MUAE_ONMYPHONECHANGE 		  0x40e
#define DISPID_MUAE_ONUNREADEMAILCHANGE 	  0x40f
#define DISPID_MUAE_ONIMWINDOWCREATED		  0x411
#define DISPID_MUAE_ONIMWINDOWDESTROYED		  0x412
#define DISPID_MUAE_ONIMWINDOWADD			  0x413
#define DISPID_MUAE_ONIMWINDOWREMOVE		  0x414
#define DISPID_MUAE_ADDGROUP						0x415
#define DISPID_MUAE_REMOVEGROUP					0x416
#define DISPID_MUAE_RENAMEGROUP					0x417
#define DISPID_MUAE_ADD_USRGRP						0x418
#define DISPID_MUAE_REMOVE_USRGRP	

class Host;
class MessengerEvents;

class Host : public IUnknown 
{
public:
	Host();
	virtual ~Host();
	ULONG STDMETHODCALLTYPE AddRef();
	ULONG STDMETHODCALLTYPE Release();
	STDMETHODIMP QueryInterface(REFIID iid, void ** ppvObject);

	MessengerEvents *m_pMessengerEvents;
	DWORD m_dwRefCount;
	DWORD m_dwCookie;
	IConnectionPoint *m_pConnectionPoint; 
};

extern Host *pHost;

class MessengerEvents : public IDispatch {
public:
    MessengerEvents(Host *phost);
    virtual ~MessengerEvents();
    STDMETHODIMP QueryInterface(REFIID iid, void ** ppvObject);
    ULONG STDMETHODCALLTYPE AddRef();
    ULONG STDMETHODCALLTYPE Release();
    HRESULT STDMETHODCALLTYPE GetTypeInfoCount(unsigned int FAR* pctinfo);
    HRESULT STDMETHODCALLTYPE GetTypeInfo(unsigned int iTInfo, LCID  lcid,
                                          ITypeInfo FAR* FAR*  ppTInfo);
    HRESULT STDMETHODCALLTYPE GetIDsOfNames(REFIID riid, OLECHAR FAR* FAR* rgszNames,
                                            unsigned int cNames, LCID lcid, DISPID FAR* rgDispId);
    HRESULT STDMETHODCALLTYPE Invoke(DISPID dispIdMember, REFIID riid, LCID lcid, WORD wFlags,
                                     DISPPARAMS FAR* pDispParams, VARIANT FAR* parResult,
                                     EXCEPINFO FAR* pExcepInfo, unsigned int FAR* puArgErr);
private:
    Host *m_pHost;
};

#endif //MESSENGEREVENTS_H