/*
	TDialog DLL v0.1
	by ClickHeRe
	panodude@videotron.ca

	This DLL lets you make some mIRC dialogs transparent.
*/
#pragma check_stack(off)
#pragma comment(linker,"/OPT:NOWIN98")
#pragma comment(linker, "/IGNORE:4089")

#define WIN32_LEAN_AND_MEAN

#ifndef WS_EX_LAYERED
#define WS_EX_LAYERED           0x00080000
#define LWA_COLORKEY            0x00000001
#define LWA_ALPHA               0x00000002
#endif // ndef WS_EX_LAYERED


#include <windows.h>
#include <stdlib.h>
#include <string>

using namespace std;

// alias to define an External DLL Command
#define mIRC(x) int __stdcall WINAPI x(HWND mWnd,HWND aWnd,char *data,char*,BOOL,BOOL)
// alias to define a WNDPROC function
#define Proc(x) LRESULT CALLBACK x(HWND hwnd,UINT uMsg,WPARAM wParam,LPARAM lParam)
#define ret(x) { strcpy(data,x); strcat(data,"\0"); return 3; }


void TrimLeft(string& Target, const string& CmpTo);
void TrimRight(string& Target, const string& CmpTo);
//char *Trim(char *str);
void Trim(char *str);

BOOL GoodOs();

// ##################################################################################################

// Global Vars
HANDLE hFileMap;
LPSTR mData;
HWND mIRC_hwnd;

// transparent typedef
typedef BOOL (WINAPI *lpfnSetLayeredWindowAttributes)(HWND hWnd, COLORREF crKey, BYTE bAlpha, DWORD dwFlags);
lpfnSetLayeredWindowAttributes m_pSetLayeredWindowAttributes;


// ##################################################################################################

// default Load DLL structure
typedef struct {
    DWORD  mVersion;
    HWND   mHwnd;
    BOOL   mKeep;
} LOADINFO;


// ##################################################################################################

void TrimLeft(string& Target, const string& CmpTo)
{
    while(!Target.find(CmpTo))
    {
         Target.erase(Target.begin(), Target.begin()+CmpTo.size());
    }
}

// Trim right function
void TrimRight(string& Target, const string& CmpTo)
{
    size_t p = string::npos;
    for(;;)
    {
         p = Target.find(CmpTo);
         if (p == string::npos || p != Target.size() - CmpTo.size()) break;
         Target.erase(Target.end()-CmpTo.size(), Target.begin());
    }
}

//Trim leading and ending spaces
void Trim(char *str)
{
  string com(str);
  TrimLeft(com, " ");
	TrimRight(com, " ");
  char *com2 = (char *) com.c_str();
	lstrcpy(str,com2);
}

// ##################################################################################################
// Load DLL command
void WINAPI LoadDll(LOADINFO* load)
{
	hFileMap = CreateFileMapping(INVALID_HANDLE_VALUE,0,PAGE_READWRITE,0,4096,"mIRC");     
  mData = (LPSTR)MapViewOfFile(hFileMap,FILE_MAP_ALL_ACCESS,0,0,0);
  mIRC_hwnd = load->mHwnd;
}

// Unload DLL command
int WINAPI UnloadDll(int timeout)
{
	if (!timeout)
  { 
		UnmapViewOfFile(mData);
		CloseHandle(hFileMap);
		return 1;
	}
  else return 0;
}

BOOL GoodOs()
{
	OSVERSIONINFO os = { sizeof(os) };
	GetVersionEx(&os);
	// use m_bWin2k before any call to the m_pSetLayeredWindowAttributes to make sure we are runninng Win2K
	BOOL m_bWin2K = ( VER_PLATFORM_WIN32_NT == os.dwPlatformId && os.dwMajorVersion >= 5 ); 
	return m_bWin2K;
}

// ##################################################################################################
// External DLL Commands
mIRC(Version) 
{
	ret("TDialog DLL v0.1 by ClickHeRe 2003 - http://metax.scriptsdb.org");
}

mIRC(TDDialog) 
{
	char chwnd[100], cnAlpha[100];
	HWND hwnd;
	int nAlpha;

	if (!GoodOs())
		ret("T_ERROR TDialog only works on Win 2k/XP");

	lstrcpy(chwnd,strtok(data,">"));
	lstrcpy(cnAlpha,strtok(NULL,""));

	Trim(chwnd);
	Trim(cnAlpha);

	hwnd = (HWND) atoi(chwnd);
	nAlpha = (int) atoi(cnAlpha);

	if (nAlpha > 100 || nAlpha < 0)
		ret("T_ERROR Invalid Transparency Value, Must Be 0-100");

	if (!IsWindow(hwnd))
		ret("T_ERROR Invalid Window Handle");


	HMODULE hUser32 = GetModuleHandle("USER32.DLL");
	m_pSetLayeredWindowAttributes = (lpfnSetLayeredWindowAttributes)GetProcAddress(hUser32, "SetLayeredWindowAttributes");

	// If the import did not succeed, make sure your app can handle it!
	if (NULL == m_pSetLayeredWindowAttributes)
		ret("T_ERROR Window Does Not Support Transparency");


	SetWindowLong(hwnd, GWL_EXSTYLE, GetWindowLong(hwnd, GWL_EXSTYLE) | WS_EX_LAYERED);
  m_pSetLayeredWindowAttributes(hwnd, 0, (255 / 100) *(100-nAlpha), LWA_ALPHA);

	ret("T_OK");
}

mIRC(TDColor) 
{

	char chwnd[100], cnAlpha[100], cColor[100];
	HWND hwnd;
	int nAlpha;
	COLORREF Color;

	if (!GoodOs())
		ret("T_ERROR TDialog only works on Win 2k/XP");

	lstrcpy(chwnd,strtok(data,">"));
	lstrcpy(cnAlpha,strtok(NULL,">"));
	lstrcpy(cColor,strtok(NULL,""));

	Trim(chwnd);
	Trim(cnAlpha);
	Trim(cColor);

	hwnd = (HWND) atoi(chwnd);
	nAlpha = (int) atoi(cnAlpha);
	Color = (COLORREF) atoi(cColor);

	if (nAlpha > 100 || nAlpha < 0)
		ret("T_ERROR Invalid Transparency Value, Must Be 0-100");

	if (!IsWindow(hwnd))
		ret("T_ERROR Invalid Window Handle");


	HMODULE hUser32 = GetModuleHandle("USER32.DLL");
	m_pSetLayeredWindowAttributes = (lpfnSetLayeredWindowAttributes)GetProcAddress(hUser32, "SetLayeredWindowAttributes");

	// If the import did not succeed, make sure your app can handle it!
	if (NULL == m_pSetLayeredWindowAttributes)
		ret("T_ERROR Window Does Not Support Transparency");


	SetWindowLong(hwnd, GWL_EXSTYLE, GetWindowLong(hwnd, GWL_EXSTYLE) | WS_EX_LAYERED);
  m_pSetLayeredWindowAttributes(hwnd, Color, (255 / 100) *(100-nAlpha), LWA_COLORKEY);

  ret("T_OK");
}